/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StaxParser {
    public static String getXMLContent(XMLStreamReader reader) throws XMLStreamException {
        while (reader.getEventType() == 7 && reader.hasNext()) {
            reader.next();
        }
        StringBuilder content = new StringBuilder();
        String parentTag = reader.getLocalName();
        int depth = 1;
        content.append(StaxParser.getXMLStartTag(reader, true));
        while (reader.hasNext()) {
            String tagName;
            int event = reader.next();
            if (event == 1) {
                tagName = reader.getLocalName();
                if (tagName.equals(parentTag)) {
                    ++depth;
                }
                content.append(StaxParser.getXMLStartTag(reader, false));
                continue;
            }
            if (event == 2) {
                tagName = reader.getLocalName();
                content.append(StaxParser.getXMLEndTag(reader));
                if (!tagName.equals(parentTag) || --depth != 0) continue;
                break;
            }
            if (event == 4) {
                content.append(StaxParser.getXMLText(reader));
                continue;
            }
            if (event == 12) {
                content.append(StaxParser.getXMLCData(reader));
                continue;
            }
            if (event == 5) {
                content.append(StaxParser.getXMLComment(reader));
                continue;
            }
            if (event == 3) {
                content.append(StaxParser.getXMLProcessingInstruction(reader));
                continue;
            }
            if (event != 6 && event != 9) continue;
            content.append(StaxParser.getXMLText(reader));
        }
        return content.toString().trim();
    }

    private static String getXMLStartTag(XMLStreamReader reader, boolean addNamespaceURI) {
        StringBuilder startTag = new StringBuilder();
        String prefix = reader.getPrefix();
        startTag.append("<").append((String)(prefix != null && !prefix.isBlank() ? prefix + ":" : "")).append(reader.getName().getLocalPart());
        String namespaceURI = reader.getNamespaceURI();
        if (addNamespaceURI && namespaceURI != null) {
            startTag.append(" xmlns").append((String)(prefix != null && !prefix.isBlank() ? ":" + prefix : "")).append("=\"").append(namespaceURI).append("\"");
        }
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            startTag.append(" ").append(reader.getAttributeLocalName(i)).append("=\"").append(reader.getAttributeValue(i)).append("\"");
        }
        if (reader.isEndElement()) {
            startTag.append("/");
        }
        startTag.append(">");
        return startTag.toString();
    }

    private static String getXMLEndTag(XMLStreamReader reader) {
        StringBuilder endTag = new StringBuilder();
        String prefix = reader.getPrefix();
        endTag.append("</").append((String)(prefix != null && !prefix.isBlank() ? prefix + ":" : "")).append(reader.getName().getLocalPart()).append(">");
        return endTag.toString();
    }

    private static String getXMLCData(XMLStreamReader reader) {
        return "<![CDATA[" + reader.getText() + "]]>";
    }

    private static String getXMLComment(XMLStreamReader reader) {
        return "<!--" + reader.getText() + "-->";
    }

    private static String getXMLProcessingInstruction(XMLStreamReader reader) {
        return "<?" + reader.getPITarget() + " " + reader.getPIData() + "?>";
    }

    private static String getXMLText(XMLStreamReader reader) {
        return reader.getText().trim();
    }
}

