/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.strings.StringUtil;
import org.jspecify.annotations.NonNull;

public class AuthorListParser {
    private static final Set<String> AVOID_TERMS_IN_LOWER_CASE = Set.of("jr", "sr", "jnr", "snr", "von", "zu", "van", "der");
    private static final int TOKEN_GROUP_LENGTH = 4;
    private static final int OFFSET_TOKEN = 0;
    private static final int OFFSET_TOKEN_ABBR = 1;
    private static final int OFFSET_TOKEN_TERM = 2;
    private static final Set<String> TEX_NAMES = Set.of("aa", "ae", "l", "o", "oe", "i", "AA", "AE", "L", "O", "OE", "j");
    private static final Pattern STARTS_WITH_CAPITAL_LETTER_DOT = Pattern.compile("^[A-Z]\\. ");
    private String original;
    private int tokenStart;
    private int tokenEnd;
    private int tokenAbbrEnd;
    private char tokenTerm;
    private boolean tokenCase;

    private static StringBuilder buildWithAffix(Collection<Integer> indexArray, List<String> nameList) {
        StringBuilder stringBuilder = new StringBuilder();
        int avoidedTimes = 0;
        for (int i = 0; i < nameList.size(); ++i) {
            if (indexArray.contains(i)) {
                stringBuilder.append(nameList.get(i));
                stringBuilder.append(',');
                ++avoidedTimes;
                continue;
            }
            stringBuilder.append(nameList.get(i));
            if ((i + avoidedTimes) % 2 == 0) {
                stringBuilder.append(',');
                continue;
            }
            stringBuilder.append(';');
        }
        return stringBuilder;
    }

    public AuthorList parse(@NonNull String listOfNames) {
        boolean authorsContainTwoOrMoreCommas;
        boolean andOthersPresent;
        listOfNames = listOfNames.trim();
        String andOthersSuffix = " and others";
        if (StringUtil.endsWithIgnoreCase(listOfNames, " and others")) {
            andOthersPresent = true;
            listOfNames = StringUtil.removeStringAtTheEnd(listOfNames, " and others");
        } else {
            andOthersPresent = false;
        }
        listOfNames = AuthorListParser.checkNamesCommaSeparated(listOfNames);
        boolean authorsContainAND = listOfNames.toUpperCase(Locale.ENGLISH).contains(" AND ");
        boolean authorsContainOpeningBrace = listOfNames.contains("{");
        boolean authorsContainSemicolon = listOfNames.contains(";");
        boolean bl = authorsContainTwoOrMoreCommas = listOfNames.length() - listOfNames.replace(",", "").length() >= 2;
        if (!authorsContainAND && !authorsContainOpeningBrace && !authorsContainSemicolon && authorsContainTwoOrMoreCommas) {
            boolean spaceInAllParts;
            List<String> arrayNameList = Arrays.asList(listOfNames.split(","));
            arrayNameList.replaceAll(String::trim);
            boolean bl2 = spaceInAllParts = arrayNameList.stream().filter(name -> name.contains(" ")).count() == (long)arrayNameList.size();
            if (spaceInAllParts) {
                listOfNames = listOfNames.replace(",", " and");
            } else {
                int valuePartsCount = arrayNameList.size();
                HashSet<Integer> avoidIndex = new HashSet<Integer>();
                for (int i = 0; i < arrayNameList.size(); ++i) {
                    if (!AVOID_TERMS_IN_LOWER_CASE.contains(arrayNameList.get(i).toLowerCase(Locale.ROOT))) continue;
                    avoidIndex.add(i);
                    --valuePartsCount;
                }
                if (valuePartsCount % 2 == 0) {
                    listOfNames = AuthorListParser.buildWithAffix(avoidIndex, arrayNameList).toString();
                }
            }
        }
        this.original = listOfNames;
        this.tokenStart = 0;
        this.tokenEnd = 0;
        ArrayList<Author> authors = new ArrayList<Author>(5);
        while (this.tokenStart < this.original.length()) {
            this.getAuthor().ifPresent(authors::add);
        }
        if (andOthersPresent) {
            authors.add(Author.OTHERS);
        }
        return AuthorList.of(authors);
    }

    private static String checkNamesCommaSeparated(String listOfNames) {
        String namesBeforeAndString;
        String[] namesBeforeAnd;
        String lastContainedName;
        Matcher matcher;
        int commandAndPos = listOfNames.lastIndexOf(", and ");
        if (commandAndPos >= 0 && (matcher = STARTS_WITH_CAPITAL_LETTER_DOT.matcher(lastContainedName = listOfNames.substring(commandAndPos + ", and ".length()))).find() && Arrays.stream(namesBeforeAnd = (namesBeforeAndString = listOfNames.substring(0, commandAndPos)).split(", ")).allMatch(name -> STARTS_WITH_CAPITAL_LETTER_DOT.matcher((CharSequence)name).find())) {
            listOfNames = Arrays.stream(namesBeforeAnd).collect(Collectors.joining(" and ", "", " and " + lastContainedName));
        }
        return listOfNames;
    }

    private Optional<Author> getAuthor() {
        String jrPart;
        int firstPartEnd;
        ArrayList<Object> tokens = new ArrayList<Object>();
        int vonStart = -1;
        int lastStart = -1;
        int commaFirst = -1;
        int commaSecond = -1;
        boolean continueLoop = true;
        while (continueLoop) {
            Token token = this.getToken();
            switch (token.ordinal()) {
                case 0: 
                case 1: {
                    continueLoop = false;
                    break;
                }
                case 2: {
                    if (commaFirst < 0) {
                        commaFirst = tokens.size();
                        break;
                    }
                    if (commaSecond >= 0) break;
                    commaSecond = tokens.size();
                    break;
                }
                case 3: {
                    tokens.add(this.original.substring(this.tokenStart, this.tokenEnd));
                    tokens.add(this.original.substring(this.tokenStart, this.tokenAbbrEnd));
                    tokens.add(Character.valueOf(this.tokenTerm));
                    tokens.add(this.tokenCase);
                    if (commaFirst >= 0 || lastStart >= 0) break;
                    if (vonStart < 0) {
                        int thisTermToken;
                        int previousTermToken;
                        if (this.tokenCase || (previousTermToken = tokens.size() - 4 - 4 + 2) >= 0 && tokens.get(previousTermToken).equals(Character.valueOf('-')) || (thisTermToken = previousTermToken + 4) >= 0 && tokens.get(thisTermToken).equals(Character.valueOf('-'))) break;
                        vonStart = tokens.size() - 4;
                        break;
                    }
                    if (!this.tokenCase) break;
                    lastStart = tokens.size() - 4;
                    break;
                }
            }
        }
        if (tokens.isEmpty()) {
            return Optional.empty();
        }
        int firstPartStart = -1;
        int vonPartStart = -1;
        int lastPartStart = -1;
        int jrPartStart = -1;
        int vonPartEnd = 0;
        int lastPartEnd = 0;
        int jrPartEnd = 0;
        if (commaFirst < 0) {
            if (vonStart < 0) {
                Character ch;
                lastPartEnd = tokens.size();
                lastPartStart = tokens.size() - 4;
                int index = tokens.size() - 8 + 2;
                if (index > 0 && (ch = (Character)tokens.get(index)).charValue() == '-') {
                    lastPartStart -= 4;
                }
                if ((firstPartEnd = lastPartStart) > 0) {
                    firstPartStart = 0;
                }
            } else {
                if (lastStart >= 0) {
                    lastPartEnd = tokens.size();
                    vonPartEnd = lastPartStart = lastStart;
                } else {
                    vonPartEnd = tokens.size();
                }
                firstPartEnd = vonPartStart = vonStart;
                if (firstPartEnd > 0) {
                    firstPartStart = 0;
                }
            }
        } else {
            firstPartEnd = tokens.size();
            if (commaSecond < 0) {
                if (commaFirst < firstPartEnd) {
                    firstPartStart = commaFirst;
                }
            } else {
                if (commaSecond < firstPartEnd) {
                    firstPartStart = commaSecond;
                }
                if (commaFirst < (jrPartEnd = commaSecond)) {
                    jrPartStart = commaFirst;
                }
            }
            if (vonStart == 0) {
                if (lastStart < 0) {
                    vonPartEnd = commaFirst;
                } else {
                    lastPartEnd = commaFirst;
                    vonPartEnd = lastPartStart = lastStart;
                }
                vonPartStart = 0;
            } else {
                lastPartEnd = commaFirst;
                if (lastPartEnd > 0) {
                    lastPartStart = 0;
                }
            }
        }
        if (firstPartStart == -1 && lastPartStart == -1 && vonPartStart != -1) {
            lastPartStart = vonPartStart;
            lastPartEnd = vonPartEnd;
            vonPartStart = -1;
            vonPartEnd = -1;
        }
        String firstPart = firstPartStart < 0 ? null : this.concatTokens(tokens, firstPartStart, firstPartEnd, 0, false);
        String firstAbbr = firstPartStart < 0 ? null : this.concatTokens(tokens, firstPartStart, firstPartEnd, 1, true);
        String vonPart = vonPartStart < 0 ? null : this.concatTokens(tokens, vonPartStart, vonPartEnd, 0, false);
        String lastPart = lastPartStart < 0 ? null : this.concatTokens(tokens, lastPartStart, lastPartEnd, 0, false);
        String string = jrPart = jrPartStart < 0 ? null : this.concatTokens(tokens, jrPartStart, jrPartEnd, 0, false);
        if (commaFirst < 0 && firstPart != null && lastPart != null && lastPart.equals(lastPart.toUpperCase(Locale.ROOT)) && lastPart.length() < 5 && Character.UnicodeScript.of(lastPart.charAt(0)) != Character.UnicodeScript.HAN) {
            return Optional.of(new Author(lastPart, lastPart, vonPart, firstPart, jrPart));
        }
        return Optional.of(new Author(firstPart, firstAbbr, vonPart, lastPart, jrPart));
    }

    private String concatTokens(List<Object> tokens, int start, int end, int offset, boolean dotAfter) {
        StringBuilder result = new StringBuilder();
        result.append((String)tokens.get(start + offset));
        if (dotAfter) {
            result.append('.');
        }
        for (int updatedStart = start + 4; updatedStart < end; updatedStart += 4) {
            result.append(tokens.get(updatedStart - 4 + 2));
            result.append((String)tokens.get(updatedStart + offset));
            if (!dotAfter) continue;
            result.append('.');
        }
        return result.toString();
    }

    private Token getToken() {
        char c;
        this.tokenStart = this.tokenEnd;
        while (this.tokenStart < this.original.length() && ((c = this.original.charAt(this.tokenStart)) == '~' || c == '-' || Character.isWhitespace(c))) {
            ++this.tokenStart;
        }
        this.tokenEnd = this.tokenStart;
        if (this.tokenStart >= this.original.length()) {
            return Token.EOF;
        }
        if (this.original.charAt(this.tokenStart) == ',') {
            ++this.tokenEnd;
            return Token.COMMA;
        }
        if (this.original.charAt(this.tokenStart) == ';') {
            ++this.tokenEnd;
            return Token.AND;
        }
        this.tokenAbbrEnd = -1;
        this.tokenTerm = (char)32;
        this.tokenCase = true;
        int bracesLevel = 0;
        int currentBackslash = -1;
        boolean firstLetterIsFound = false;
        while (this.tokenEnd < this.original.length()) {
            char c2 = this.original.charAt(this.tokenEnd);
            if (c2 == '{') {
                ++bracesLevel;
            }
            if (firstLetterIsFound && this.tokenAbbrEnd < 0 && (bracesLevel == 0 || c2 == '{')) {
                this.tokenAbbrEnd = this.tokenEnd;
            }
            if (c2 == '}' && bracesLevel > 0) {
                --bracesLevel;
            }
            if (!firstLetterIsFound && currentBackslash < 0 && Character.isLetter(c2)) {
                this.tokenCase = bracesLevel == 0 ? Character.isUpperCase(c2) || Character.UnicodeScript.of(c2) == Character.UnicodeScript.HAN : true;
                firstLetterIsFound = true;
            }
            if (currentBackslash >= 0 && !Character.isLetter(c2)) {
                String texCmdName;
                if (!firstLetterIsFound && TEX_NAMES.contains(texCmdName = this.original.substring(currentBackslash + 1, this.tokenEnd))) {
                    this.tokenCase = Character.isUpperCase(texCmdName.charAt(0));
                    firstLetterIsFound = true;
                }
                currentBackslash = -1;
            }
            if (c2 == '\\') {
                currentBackslash = this.tokenEnd;
            }
            if (bracesLevel == 0 && (",;-".indexOf(c2) != -1 || Character.isWhitespace(c2))) break;
            ++this.tokenEnd;
        }
        if (this.tokenAbbrEnd < 0) {
            this.tokenAbbrEnd = this.tokenEnd;
        }
        if (this.tokenEnd < this.original.length() && this.original.charAt(this.tokenEnd) == '-') {
            this.tokenTerm = (char)45;
        }
        if ("and".equalsIgnoreCase(this.original.substring(this.tokenStart, this.tokenEnd))) {
            return Token.AND;
        }
        return Token.WORD;
    }

    private static enum Token {
        EOF,
        AND,
        COMMA,
        WORD;

    }
}

