/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jabref.logic.bibtex.BibEntryWriter;
import org.jabref.logic.bibtex.FieldPreferences;
import org.jabref.logic.bibtex.FieldWriter;
import org.jabref.logic.bibtex.InvalidFieldValueException;
import org.jabref.logic.citationkeypattern.CitationKeyPatternPreferences;
import org.jabref.logic.exporter.BibDatabaseWriter;
import org.jabref.logic.exporter.BibWriter;
import org.jabref.logic.exporter.MetaDataSerializer;
import org.jabref.logic.exporter.SelfContainedSaveConfiguration;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.BibtexString;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BibtexDatabaseWriter
extends BibDatabaseWriter {
    public static final String DATABASE_ID_PREFIX = "DBID:";
    private static final Logger LOGGER = LoggerFactory.getLogger(BibtexDatabaseWriter.class);
    private static final String COMMENT_PREFIX = "@Comment";
    private static final String PREAMBLE_PREFIX = "@Preamble";
    private static final String STRING_PREFIX = "@String";

    public BibtexDatabaseWriter(BibWriter bibWriter, SelfContainedSaveConfiguration saveConfiguration, FieldPreferences fieldPreferences, CitationKeyPatternPreferences citationKeyPatternPreferences, BibEntryTypesManager entryTypesManager) {
        super(bibWriter, saveConfiguration, fieldPreferences, citationKeyPatternPreferences, entryTypesManager);
    }

    public BibtexDatabaseWriter(Writer writer, String newline, SelfContainedSaveConfiguration saveConfiguration, FieldPreferences fieldPreferences, CitationKeyPatternPreferences citationKeyPatternPreferences, BibEntryTypesManager entryTypesManager) {
        super(new BibWriter(writer, newline), saveConfiguration, fieldPreferences, citationKeyPatternPreferences, entryTypesManager);
    }

    @Override
    protected void writeEpilogue(String epilogue) throws IOException {
        if (!StringUtil.isNullOrEmpty(epilogue)) {
            this.bibWriter.write(epilogue);
            this.bibWriter.finishBlock();
        }
    }

    @Override
    protected void writeMetaDataItem(Map.Entry<String, String> metaItem) throws IOException {
        this.bibWriter.write("@Comment{");
        this.bibWriter.write("jabref-meta: ");
        this.bibWriter.write(metaItem.getKey());
        this.bibWriter.write(":");
        this.bibWriter.write(metaItem.getValue());
        this.bibWriter.write("}");
        this.bibWriter.finishBlock();
    }

    @Override
    protected void writePreamble(String preamble) throws IOException {
        if (!StringUtil.isNullOrEmpty(preamble)) {
            this.bibWriter.write("@Preamble{");
            this.bibWriter.write(preamble);
            this.bibWriter.writeLine("}");
            this.bibWriter.finishBlock();
        }
    }

    @Override
    protected void writeString(BibtexString bibtexString, int maxKeyLength) throws IOException {
        if (!this.saveConfiguration.shouldReformatFile() && !bibtexString.hasChanged()) {
            LOGGER.debug("Writing parsed serialization {}.", (Object)bibtexString.getParsedSerialization());
            this.bibWriter.write(bibtexString.getParsedSerialization());
            return;
        }
        String userComments = bibtexString.getUserComments();
        if (!userComments.isEmpty()) {
            this.bibWriter.writeLine(userComments);
        }
        this.bibWriter.write("@String{" + bibtexString.getName() + StringUtil.repeatSpaces(maxKeyLength - bibtexString.getName().length()) + " = ");
        if (bibtexString.getContent().isEmpty()) {
            this.bibWriter.write("{}");
        } else {
            try {
                String formatted = new FieldWriter(this.fieldPreferences).write(InternalField.BIBTEX_STRING, bibtexString.getContent());
                this.bibWriter.write(formatted);
            }
            catch (InvalidFieldValueException ex) {
                throw new IOException(ex);
            }
        }
        this.bibWriter.writeLine("}");
    }

    @Override
    protected void writeEntryTypeDefinition(BibEntryType customType) throws IOException {
        this.bibWriter.write("@Comment{");
        this.bibWriter.write(MetaDataSerializer.serializeCustomEntryTypes(customType));
        this.bibWriter.writeLine("}");
        this.bibWriter.finishBlock();
    }

    @Override
    protected void writeProlog(BibDatabaseContext bibDatabaseContext, Charset encoding) throws IOException {
        if (encoding == null || !bibDatabaseContext.getMetaData().getEncodingExplicitlySupplied() && encoding.equals(StandardCharsets.UTF_8)) {
            return;
        }
        this.bibWriter.write("% ");
        this.bibWriter.writeLine("Encoding: " + String.valueOf(encoding));
    }

    @Override
    protected void writeDatabaseID(String sharedDatabaseID) throws IOException {
        this.bibWriter.write("% ");
        this.bibWriter.write(DATABASE_ID_PREFIX);
        this.bibWriter.write(" ");
        this.bibWriter.writeLine(sharedDatabaseID);
    }

    @Override
    protected void writeEntry(BibEntry entry, BibDatabaseMode mode) throws IOException {
        BibEntryWriter bibtexEntryWriter = new BibEntryWriter(new FieldWriter(this.fieldPreferences), this.entryTypesManager);
        bibtexEntryWriter.write(entry, this.bibWriter, mode, this.saveConfiguration.shouldReformatFile());
    }
}

