/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex.comparator;

import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.model.entry.field.InternalField;

public class EntryComparator
implements Comparator<BibEntry> {
    private final Field sortField;
    private final boolean descending;
    private final boolean binary;
    private final Comparator<BibEntry> next;

    public EntryComparator(boolean binary, boolean descending, Field field, Comparator<BibEntry> next) {
        this.binary = binary;
        this.sortField = field;
        this.descending = descending;
        this.next = next;
    }

    public EntryComparator(boolean binary, boolean descending, Field field) {
        this.binary = binary;
        this.sortField = field;
        this.descending = descending;
        this.next = null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int compare(BibEntry e1, BibEntry e2) {
        if (Objects.equals(e1, e2)) {
            return 0;
        }
        f1 = e1.getField(this.sortField).orElse(null);
        f2 = e2.getField(this.sortField).orElse(null);
        if (this.binary) {
            if (f1 == null) {
                return f2 == null ? (this.next == null ? EntryComparator.idCompare(e1, e2) : this.next.compare(e1, e2)) : 1;
            }
            return f2 == null ? -1 : (this.next == null ? EntryComparator.idCompare(e1, e2) : this.next.compare(e1, e2));
        }
        if (this.sortField.getProperties().contains((Object)FieldProperty.PERSON_NAMES)) {
            if (f1 != null) {
                f1 = AuthorList.fixAuthorForAlphabetization((String)f1).toLowerCase(Locale.ROOT);
            }
            if (f2 != null) {
                f2 = AuthorList.fixAuthorForAlphabetization((String)f2).toLowerCase(Locale.ROOT);
            }
        } else if (this.sortField.equals(InternalField.TYPE_HEADER)) {
            f1 = e1.getType();
            f2 = e2.getType();
        } else if (this.sortField.equals(InternalField.KEY_FIELD)) {
            f1 = e1.getCitationKey().orElse(null);
            f2 = e2.getCitationKey().orElse(null);
        } else if (this.sortField.isNumeric()) {
            try {
                i1 = Integer.parseInt((String)f1);
                i2 = Integer.parseInt((String)f2);
                f1 = i1;
                f2 = i2;
            }
            catch (NumberFormatException i1) {
                // empty catch block
            }
        }
        if (f2 == null) {
            if (f1 == null) {
                return this.next == null ? EntryComparator.idCompare(e1, e2) : this.next.compare(e1, e2);
            }
            return 1;
        }
        if (f1 == null) {
            return -1;
        }
        if (!(f1 instanceof Integer)) ** GOTO lbl-1000
        f1i = (Integer)f1;
        if (f2 instanceof Integer) {
            f2i = (Integer)f2;
            result = f1i.compareTo(f2i);
        } else if (f2 instanceof Integer) {
            integer = (Integer)f2;
            f1AsInteger = Integer.valueOf(f1.toString());
            result = f1AsInteger.compareTo(integer);
        } else if (f1 instanceof Integer) {
            integer = (Integer)f1;
            f2AsInteger = Integer.valueOf(f2.toString());
            result = integer.compareTo(f2AsInteger);
        } else {
            ours = ((String)f1).toLowerCase(Locale.ROOT);
            theirs = ((String)f2).toLowerCase(Locale.ROOT);
            result = comp = ours.compareTo(theirs);
        }
        if (result != 0) {
            return this.descending != false ? -result : result;
        }
        if (this.next == null) {
            return EntryComparator.idCompare(e1, e2);
        }
        return this.next.compare(e1, e2);
    }

    private static int idCompare(BibEntry b1, BibEntry b2) {
        return b1.getId().compareTo(b2.getId());
    }
}

