/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.auxparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibtexString;

public class AuxParserResult {
    private final BibDatabase masterDatabase;
    private final Set<String> uniqueKeys = new HashSet<String>();
    private final List<String> unresolvedKeys = new ArrayList<String>();
    private final BibDatabase auxDatabase = new BibDatabase();
    private int nestedAuxCount;
    private int crossRefEntriesCount;
    private int insertedStrings;

    public AuxParserResult(BibDatabase masterDatabase) {
        this.masterDatabase = masterDatabase;
    }

    public BibDatabase getGeneratedBibDatabase() {
        return this.auxDatabase;
    }

    public List<String> getUnresolvedKeys() {
        return this.unresolvedKeys;
    }

    public int getFoundKeysInAux() {
        return this.uniqueKeys.size();
    }

    public int getResolvedKeysCount() {
        return this.auxDatabase.getEntryCount() - this.crossRefEntriesCount;
    }

    public int getUnresolvedKeysCount() {
        return this.unresolvedKeys.size();
    }

    public int getCrossRefEntriesCount() {
        return this.crossRefEntriesCount;
    }

    public void increaseCrossRefEntriesCounter() {
        ++this.crossRefEntriesCount;
    }

    public void increaseNestedAuxFilesCounter() {
        ++this.nestedAuxCount;
    }

    public void insertStrings(Collection<BibtexString> usedStrings) {
        for (BibtexString string : usedStrings) {
            this.auxDatabase.addString(string);
            ++this.insertedStrings;
        }
    }

    public BibDatabase getMasterDatabase() {
        return this.masterDatabase;
    }

    public int getNestedAuxCount() {
        return this.nestedAuxCount;
    }

    public int getInsertedStrings() {
        return this.insertedStrings;
    }

    public Set<String> getUniqueKeys() {
        return this.uniqueKeys;
    }
}

