/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import com.airhacks.afterburner.injection.Injector;
import java.util.Optional;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingRepository;

public class BaseDialog<T>
extends Dialog<T> {
    protected BaseDialog() {
        this.getDialogPane().getScene().setOnKeyPressed(event -> {
            KeyBindingRepository keyBindingRepository = (KeyBindingRepository)Injector.instantiateModelOrService(KeyBindingRepository.class);
            if (keyBindingRepository.checkKeyCombinationEquality(KeyBinding.CLOSE, (KeyEvent)event)) {
                this.close();
            } else if (keyBindingRepository.checkKeyCombinationEquality(KeyBinding.DEFAULT_DIALOG_ACTION, (KeyEvent)event)) {
                this.getDefaultButton().ifPresent(Button::fire);
            }
            if (event.getCode() == KeyCode.ENTER && event.getTarget() instanceof Button) {
                ((Button)event.getTarget()).fire();
                event.consume();
            }
        });
        this.setDialogIcon(IconTheme.getJabRefImage());
        this.setResizable(true);
    }

    private Optional<Button> getDefaultButton() {
        return Optional.ofNullable((Button)this.getDialogPane().lookupButton(this.getDefaultButtonType()));
    }

    private ButtonType getDefaultButtonType() {
        return this.getDialogPane().getButtonTypes().stream().filter(buttonType -> buttonType.getButtonData().isDefaultButton()).findFirst().orElse(ButtonType.OK);
    }

    private void setDialogIcon(Image image) {
        Stage dialogWindow = (Stage)this.getDialogPane().getScene().getWindow();
        dialogWindow.getIcons().add((Object)image);
    }
}

