/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.network;

import de.saxsys.mvvmfx.utils.validation.CompositeValidator;
import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.stage.FileChooser;
import kong.unirest.core.UnirestException;
import org.jabref.gui.DialogService;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.preferences.network.CustomCertificateViewModel;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.net.ProxyPreferences;
import org.jabref.logic.net.ProxyRegisterer;
import org.jabref.logic.net.URLDownload;
import org.jabref.logic.net.ssl.SSLCertificate;
import org.jabref.logic.net.ssl.TrustStoreManager;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.InternalPreferences;
import org.jabref.preferences.PreferencesService;

public class NetworkTabViewModel
implements PreferenceTabViewModel {
    private final BooleanProperty versionCheckProperty = new SimpleBooleanProperty();
    private final BooleanProperty proxyUseProperty = new SimpleBooleanProperty();
    private final StringProperty proxyHostnameProperty = new SimpleStringProperty("");
    private final StringProperty proxyPortProperty = new SimpleStringProperty("");
    private final BooleanProperty proxyUseAuthenticationProperty = new SimpleBooleanProperty();
    private final StringProperty proxyUsernameProperty = new SimpleStringProperty("");
    private final StringProperty proxyPasswordProperty = new SimpleStringProperty("");
    private final BooleanProperty proxyPersistPasswordProperty = new SimpleBooleanProperty();
    private final BooleanProperty passwordPersistAvailable = new SimpleBooleanProperty();
    private final ListProperty<CustomCertificateViewModel> customCertificateListProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final Validator proxyHostnameValidator;
    private final Validator proxyPortValidator;
    private final Validator proxyUsernameValidator;
    private final Validator proxyPasswordValidator;
    private final DialogService dialogService;
    private final PreferencesService preferences;
    private final ProxyPreferences proxyPreferences;
    private final ProxyPreferences backupProxyPreferences;
    private final InternalPreferences internalPreferences;
    private final TrustStoreManager trustStoreManager;
    private final AtomicBoolean sslCertificatesChanged = new AtomicBoolean(false);

    public NetworkTabViewModel(DialogService dialogService, PreferencesService preferences) {
        this.dialogService = dialogService;
        this.preferences = preferences;
        this.proxyPreferences = preferences.getProxyPreferences();
        this.internalPreferences = preferences.getInternalPreferences();
        this.backupProxyPreferences = new ProxyPreferences(this.proxyPreferences.shouldUseProxy(), this.proxyPreferences.getHostname(), this.proxyPreferences.getPort(), this.proxyPreferences.shouldUseAuthentication(), this.proxyPreferences.getUsername(), this.proxyPreferences.getPassword(), this.proxyPreferences.shouldPersistPassword());
        this.proxyHostnameValidator = new FunctionBasedValidator((ObservableValue)this.proxyHostnameProperty, input -> !StringUtil.isNullOrEmpty(input), ValidationMessage.error((String)"%s > %s %n %n %s".formatted(Localization.lang("Network", new Object[0]), Localization.lang("Proxy configuration", new Object[0]), Localization.lang("Please specify a hostname", new Object[0]))));
        this.proxyPortValidator = new FunctionBasedValidator((ObservableValue)this.proxyPortProperty, input -> this.getPortAsInt((String)input).isPresent(), ValidationMessage.error((String)"%s > %s %n %n %s".formatted(Localization.lang("Network", new Object[0]), Localization.lang("Proxy configuration", new Object[0]), Localization.lang("Please specify a port", new Object[0]))));
        this.proxyUsernameValidator = new FunctionBasedValidator((ObservableValue)this.proxyUsernameProperty, input -> !StringUtil.isNullOrEmpty(input), ValidationMessage.error((String)"%s > %s %n %n %s".formatted(Localization.lang("Network", new Object[0]), Localization.lang("Proxy configuration", new Object[0]), Localization.lang("Please specify a username", new Object[0]))));
        this.proxyPasswordValidator = new FunctionBasedValidator((ObservableValue)this.proxyPasswordProperty, input -> !input.isBlank(), ValidationMessage.error((String)"%s > %s %n %n %s".formatted(Localization.lang("Network", new Object[0]), Localization.lang("Proxy configuration", new Object[0]), Localization.lang("Please specify a password", new Object[0]))));
        this.trustStoreManager = new TrustStoreManager(Path.of(preferences.getSSLPreferences().getTruststorePath(), new String[0]));
    }

    @Override
    public void setValues() {
        this.versionCheckProperty.setValue(Boolean.valueOf(this.internalPreferences.isVersionCheckEnabled()));
        this.setProxyValues();
        this.setSSLValues();
    }

    private void setProxyValues() {
        this.proxyUseProperty.setValue(Boolean.valueOf(this.proxyPreferences.shouldUseProxy()));
        this.proxyHostnameProperty.setValue(this.proxyPreferences.getHostname());
        this.proxyPortProperty.setValue(this.proxyPreferences.getPort());
        this.proxyUseAuthenticationProperty.setValue(Boolean.valueOf(this.proxyPreferences.shouldUseAuthentication()));
        this.proxyUsernameProperty.setValue(this.proxyPreferences.getUsername());
        this.proxyPasswordProperty.setValue(this.proxyPreferences.getPassword());
        this.proxyPersistPasswordProperty.setValue(Boolean.valueOf(this.proxyPreferences.shouldPersistPassword()));
        this.passwordPersistAvailable.setValue(Boolean.valueOf(OS.isKeyringAvailable()));
    }

    private void setSSLValues() {
        this.customCertificateListProperty.clear();
        this.trustStoreManager.getCustomCertificates().forEach(cert -> this.customCertificateListProperty.add((Object)CustomCertificateViewModel.fromSSLCertificate(cert)));
        this.customCertificateListProperty.addListener(c -> {
            this.sslCertificatesChanged.set(true);
            while (c.next()) {
                CustomCertificateViewModel certificate;
                if (c.wasAdded()) {
                    certificate = (CustomCertificateViewModel)c.getAddedSubList().getFirst();
                    certificate.getPath().ifPresent(path -> this.trustStoreManager.addCertificate(this.formatCustomAlias(certificate.getThumbprint()), Path.of(path, new String[0])));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                certificate = (CustomCertificateViewModel)c.getRemoved().getFirst();
                this.trustStoreManager.deleteCertificate(this.formatCustomAlias(certificate.getThumbprint()));
            }
        });
    }

    @Override
    public void storeSettings() {
        this.proxyPreferences.setUseProxy(this.proxyUseProperty.getValue());
        this.proxyPreferences.setHostname(this.proxyHostnameProperty.getValue().trim());
        this.proxyPreferences.setPort(this.proxyPortProperty.getValue().trim());
        this.proxyPreferences.setUseAuthentication(this.proxyUseAuthenticationProperty.getValue());
        this.proxyPreferences.setUsername(this.proxyUsernameProperty.getValue().trim());
        this.proxyPreferences.setPersistPassword(this.proxyPersistPasswordProperty.getValue());
        this.proxyPreferences.setPassword(this.proxyPasswordProperty.getValue());
        ProxyRegisterer.register(this.proxyPreferences);
        this.trustStoreManager.flush();
    }

    private Optional<Integer> getPortAsInt(String value) {
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public ValidationStatus proxyHostnameValidationStatus() {
        return this.proxyHostnameValidator.getValidationStatus();
    }

    public ValidationStatus proxyPortValidationStatus() {
        return this.proxyPortValidator.getValidationStatus();
    }

    public ValidationStatus proxyUsernameValidationStatus() {
        return this.proxyUsernameValidator.getValidationStatus();
    }

    public ValidationStatus proxyPasswordValidationStatus() {
        return this.proxyPasswordValidator.getValidationStatus();
    }

    @Override
    public boolean validateSettings() {
        ValidationStatus validationStatus;
        CompositeValidator validator = new CompositeValidator();
        if (this.proxyUseProperty.getValue().booleanValue()) {
            validator.addValidators(new Validator[]{this.proxyHostnameValidator});
            validator.addValidators(new Validator[]{this.proxyPortValidator});
            if (this.proxyUseAuthenticationProperty.getValue().booleanValue()) {
                validator.addValidators(new Validator[]{this.proxyUsernameValidator});
                validator.addValidators(new Validator[]{this.proxyPasswordValidator});
            }
        }
        if (!(validationStatus = validator.getValidationStatus()).isValid()) {
            validationStatus.getHighestMessage().ifPresent(message -> this.dialogService.showErrorDialogAndWait(message.getMessage()));
            return false;
        }
        return true;
    }

    public void checkConnection() {
        String connectionSuccessText = Localization.lang("Connection successful!", new Object[0]);
        String connectionFailedText = Localization.lang("Connection failed!", new Object[0]);
        String dialogTitle = Localization.lang("Check Proxy Setting", new Object[0]);
        String testUrl = "http://jabref.org";
        ProxyRegisterer.register(new ProxyPreferences(this.proxyUseProperty.getValue(), this.proxyHostnameProperty.getValue().trim(), this.proxyPortProperty.getValue().trim(), this.proxyUseAuthenticationProperty.getValue(), this.proxyUsernameProperty.getValue().trim(), this.proxyPasswordProperty.getValue(), this.proxyPersistPasswordProperty.getValue()));
        try {
            URLDownload urlDownload = new URLDownload("http://jabref.org");
            if (urlDownload.canBeReached()) {
                this.dialogService.showInformationDialogAndWait(dialogTitle, connectionSuccessText);
            } else {
                this.dialogService.showErrorDialogAndWait(dialogTitle, connectionFailedText);
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (UnirestException e) {
            this.dialogService.showErrorDialogAndWait(dialogTitle, connectionFailedText);
        }
        ProxyRegisterer.register(this.backupProxyPreferences);
    }

    @Override
    public List<String> getRestartWarnings() {
        if (this.sslCertificatesChanged.get()) {
            return List.of(Localization.lang("SSL configuration changed", new Object[0]));
        }
        return Collections.emptyList();
    }

    public BooleanProperty versionCheckProperty() {
        return this.versionCheckProperty;
    }

    public BooleanProperty proxyUseProperty() {
        return this.proxyUseProperty;
    }

    public StringProperty proxyHostnameProperty() {
        return this.proxyHostnameProperty;
    }

    public StringProperty proxyPortProperty() {
        return this.proxyPortProperty;
    }

    public BooleanProperty proxyUseAuthenticationProperty() {
        return this.proxyUseAuthenticationProperty;
    }

    public StringProperty proxyUsernameProperty() {
        return this.proxyUsernameProperty;
    }

    public StringProperty proxyPasswordProperty() {
        return this.proxyPasswordProperty;
    }

    public BooleanProperty proxyPersistPasswordProperty() {
        return this.proxyPersistPasswordProperty;
    }

    public ReadOnlyBooleanProperty passwordPersistAvailable() {
        return this.passwordPersistAvailable;
    }

    public ListProperty<CustomCertificateViewModel> customCertificateListProperty() {
        return this.customCertificateListProperty;
    }

    public void addCertificateFile() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(new FileChooser.ExtensionFilter(Localization.lang("SSL certificate file", new Object[0]), new String[]{"*.crt", "*.cer"})).withDefaultExtension(Localization.lang("SSL certificate file", new Object[0]), StandardFileType.CER).withInitialDirectory(this.preferences.getFilePreferences().getWorkingDirectory()).build();
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(certPath -> SSLCertificate.fromPath(certPath).ifPresent(sslCertificate -> {
            if (!this.trustStoreManager.certificateExists(this.formatCustomAlias(sslCertificate.getSHA256Thumbprint()))) {
                this.customCertificateListProperty.add((Object)CustomCertificateViewModel.fromSSLCertificate(sslCertificate).setPath(certPath.toAbsolutePath().toString()));
            } else {
                this.dialogService.showWarningDialogAndWait(Localization.lang("Duplicate Certificates", new Object[0]), Localization.lang("You already added this certificate", new Object[0]));
            }
        }));
    }

    private String formatCustomAlias(String thumbprint) {
        return "%s[custom]".formatted(thumbprint);
    }
}

