/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.openoffice;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import jakarta.inject.Inject;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.VBox;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.openoffice.StyleSelectDialogViewModel;
import org.jabref.gui.openoffice.StyleSelectItemViewModel;
import org.jabref.gui.preview.PreviewViewer;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.gui.util.ViewModelTableRowFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.TextBasedPreviewLayout;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.jabref.logic.openoffice.style.StyleLoader;
import org.jabref.logic.util.TestEntry;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.preferences.PreferencesService;

public class StyleSelectDialogView
extends BaseDialog<OOBibStyle> {
    private final MenuItem edit = new MenuItem(Localization.lang("Edit", new Object[0]));
    private final MenuItem reload = new MenuItem(Localization.lang("Reload", new Object[0]));
    private final StyleLoader loader;
    @FXML
    private TableColumn<StyleSelectItemViewModel, String> colName;
    @FXML
    private TableView<StyleSelectItemViewModel> tvStyles;
    @FXML
    private TableColumn<StyleSelectItemViewModel, String> colJournals;
    @FXML
    private TableColumn<StyleSelectItemViewModel, String> colFile;
    @FXML
    private TableColumn<StyleSelectItemViewModel, Boolean> colDeleteIcon;
    @FXML
    private Button add;
    @FXML
    private VBox vbox;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private DialogService dialogService;
    @Inject
    private StateManager stateManager;
    @Inject
    private ThemeManager themeManager;
    @Inject
    private TaskExecutor taskExecutor;
    private StyleSelectDialogViewModel viewModel;
    private PreviewViewer previewArticle;
    private PreviewViewer previewBook;

    public StyleSelectDialogView(StyleLoader loader) {
        this.loader = loader;
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.setResultConverter(button -> {
            if (button == ButtonType.OK) {
                this.viewModel.storePrefs();
                return ((StyleSelectItemViewModel)this.tvStyles.getSelectionModel().getSelectedItem()).getStyle();
            }
            return null;
        });
        this.setTitle(Localization.lang("Style selection", new Object[0]));
    }

    @FXML
    private void initialize() {
        this.viewModel = new StyleSelectDialogViewModel(this.dialogService, this.loader, this.preferencesService);
        this.previewArticle = new PreviewViewer(new BibDatabaseContext(), this.dialogService, this.preferencesService, this.stateManager, this.themeManager, this.taskExecutor);
        this.previewArticle.setEntry(TestEntry.getTestEntry());
        this.vbox.getChildren().add((Object)this.previewArticle);
        this.previewBook = new PreviewViewer(new BibDatabaseContext(), this.dialogService, this.preferencesService, this.stateManager, this.themeManager, this.taskExecutor);
        this.previewBook.setEntry(TestEntry.getTestEntryBook());
        this.vbox.getChildren().add((Object)this.previewBook);
        this.colName.setCellValueFactory(cellData -> ((StyleSelectItemViewModel)cellData.getValue()).nameProperty());
        this.colJournals.setCellValueFactory(cellData -> ((StyleSelectItemViewModel)cellData.getValue()).journalsProperty());
        this.colFile.setCellValueFactory(cellData -> ((StyleSelectItemViewModel)cellData.getValue()).fileProperty());
        this.colDeleteIcon.setCellValueFactory(cellData -> ((StyleSelectItemViewModel)cellData.getValue()).internalStyleProperty());
        new ValueTableCellFactory().withGraphic(internalStyle -> {
            if (!internalStyle.booleanValue()) {
                return IconTheme.JabRefIcons.DELETE_ENTRY.getGraphicNode();
            }
            return null;
        }).withOnMouseClickedEvent(item -> evt -> this.viewModel.deleteStyle()).withTooltip(item -> Localization.lang("Remove style", new Object[0])).install(this.colDeleteIcon);
        this.edit.setOnAction(e -> this.viewModel.editStyle());
        new ViewModelTableRowFactory<StyleSelectItemViewModel>().withOnMouseClickedEvent((item, event) -> {
            if (event.getClickCount() == 2) {
                this.viewModel.viewStyle((StyleSelectItemViewModel)item);
            }
        }).withContextMenu(item -> this.createContextMenu()).install(this.tvStyles);
        this.tvStyles.getSelectionModel().selectedItemProperty().addListener((observable, oldvalue, newvalue) -> {
            if (newvalue == null) {
                this.viewModel.selectedItemProperty().setValue(oldvalue);
            } else {
                this.viewModel.selectedItemProperty().setValue(newvalue);
            }
        });
        this.tvStyles.setItems(this.viewModel.stylesProperty());
        this.add.setGraphic(IconTheme.JabRefIcons.ADD.getGraphicNode());
        EasyBind.subscribe(this.viewModel.selectedItemProperty(), style -> {
            this.tvStyles.getSelectionModel().select(style);
            this.previewArticle.setLayout(new TextBasedPreviewLayout(style.getStyle().getReferenceFormat(StandardEntryType.Article)));
            this.previewBook.setLayout(new TextBasedPreviewLayout(style.getStyle().getReferenceFormat(StandardEntryType.Book)));
        });
    }

    private ContextMenu createContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().addAll((Object[])new MenuItem[]{this.edit, this.reload});
        return contextMenu;
    }

    @FXML
    private void addStyleFile() {
        this.viewModel.addStyleFile();
    }
}

