/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.openoffice;

import com.sun.star.bridge.UnoUrlResolver;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.comp.helper.ComponentContext;
import com.sun.star.comp.helper.ComponentContextEntry;
import com.sun.star.comp.loader.JavaLoader;
import com.sun.star.comp.servicemanager.ServiceManager;
import com.sun.star.connection.NoConnectException;
import com.sun.star.container.XSet;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.loader.XImplementationLoader;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;

public class Bootstrap {
    private static final Random RANDOM_PIPE_NAME = new Random();
    private static boolean M_LOADED_JUH = false;

    private static void insertBasicFactories(XSet xSet, XImplementationLoader xImpLoader) throws Exception {
        xSet.insert(xImpLoader.activate("com.sun.star.comp.loader.JavaLoader", null, null, null));
        xSet.insert(xImpLoader.activate("com.sun.star.comp.urlresolver.UrlResolver", null, null, null));
        xSet.insert(xImpLoader.activate("com.sun.star.comp.bridgefactory.BridgeFactory", null, null, null));
        xSet.insert(xImpLoader.activate("com.sun.star.comp.connections.Connector", null, null, null));
        xSet.insert(xImpLoader.activate("com.sun.star.comp.connections.Acceptor", null, null, null));
    }

    public static String[] getDefaultOptions() {
        return new String[]{"--nologo", "--nodefault", "--norestore", "--nolockcheck"};
    }

    public static XComponentContext createInitialComponentContext(Hashtable<String, Object> context_entries) throws Exception {
        return Bootstrap.createInitialComponentContext(context_entries);
    }

    public static XComponentContext createInitialComponentContext(Map<String, Object> context_entries) throws Exception {
        ServiceManager xSMgr = new ServiceManager();
        XImplementationLoader xImpLoader = (XImplementationLoader)UnoRuntime.queryInterface(XImplementationLoader.class, (Object)new JavaLoader());
        XInitialization xInit = (XInitialization)UnoRuntime.queryInterface(XInitialization.class, (Object)xImpLoader);
        Object[] args = new Object[]{xSMgr};
        xInit.initialize(args);
        if (context_entries == null) {
            context_entries = new HashMap<String, Object>(1);
        }
        context_entries.put("/singletons/com.sun.star.lang.theServiceManager", new ComponentContextEntry(null, (Object)xSMgr));
        ComponentContext xContext = new ComponentContext(context_entries, null);
        xSMgr.setDefaultContext((XComponentContext)xContext);
        XSet xSet = (XSet)UnoRuntime.queryInterface(XSet.class, (Object)xSMgr);
        Bootstrap.insertBasicFactories(xSet, xImpLoader);
        return xContext;
    }

    public static XMultiServiceFactory createSimpleServiceManager() throws Exception {
        return (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)Bootstrap.createInitialComponentContext((Map<String, Object>)null).getServiceManager());
    }

    public static XComponentContext defaultBootstrap_InitialComponentContext() throws Exception {
        return Bootstrap.defaultBootstrap_InitialComponentContext((String)null, (Map<String, String>)null);
    }

    public static XComponentContext defaultBootstrap_InitialComponentContext(String ini_file, Hashtable<String, String> bootstrap_parameters) throws Exception {
        return Bootstrap.defaultBootstrap_InitialComponentContext(ini_file, bootstrap_parameters);
    }

    public static XComponentContext defaultBootstrap_InitialComponentContext(String ini_file, Map<String, String> bootstrap_parameters) throws Exception {
        String[] pairs = null;
        if (null != bootstrap_parameters) {
            pairs = new String[2 * bootstrap_parameters.size()];
            int n = 0;
            for (Map.Entry<String, String> bootstrap_parameter : bootstrap_parameters.entrySet()) {
                pairs[n++] = bootstrap_parameter.getKey();
                pairs[n++] = bootstrap_parameter.getValue();
            }
        }
        if (!M_LOADED_JUH) {
            if ("The Android Project".equals(System.getProperty("java.vendor"))) {
                boolean disable_dynloading = false;
                try {
                    System.loadLibrary("lo-bootstrap");
                }
                catch (UnsatisfiedLinkError e) {
                    disable_dynloading = true;
                }
                if (!disable_dynloading) {
                    NativeLibraryLoader.loadLibrary((ClassLoader)Bootstrap.class.getClassLoader(), (String)"juh");
                }
            } else {
                NativeLibraryLoader.loadLibrary((ClassLoader)Bootstrap.class.getClassLoader(), (String)"juh");
            }
            M_LOADED_JUH = true;
        }
        return (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)Bootstrap.cppuhelper_bootstrap(ini_file, pairs, Bootstrap.class.getClassLoader()));
    }

    private static native Object cppuhelper_bootstrap(String var0, String[] var1, ClassLoader var2) throws Exception;

    public static XComponentContext bootstrap(Path ooPath) throws BootstrapException {
        String[] defaultArgArray = Bootstrap.getDefaultOptions();
        return Bootstrap.bootstrap(defaultArgArray, ooPath);
    }

    public static XComponentContext bootstrap(String[] argArray, Path path) throws BootstrapException {
        XComponentContext xContext = null;
        try {
            XComponentContext xLocalContext = Bootstrap.createInitialComponentContext((Map<String, Object>)null);
            if (xLocalContext == null) {
                throw new BootstrapException("no local component context!");
            }
            String[] cmdArray = new String[argArray.length + 2];
            cmdArray[0] = path.toAbsolutePath().toString();
            cmdArray[1] = "--accept=socket,host=localhost,port=2083;urp;";
            System.arraycopy(argArray, 0, cmdArray, 2, argArray.length);
            Process p = Runtime.getRuntime().exec(cmdArray);
            Bootstrap.pipe(p.getInputStream(), System.out, "CO> ");
            Bootstrap.pipe(p.getErrorStream(), System.err, "CE> ");
            XMultiComponentFactory xLocalServiceManager = xLocalContext.getServiceManager();
            if (xLocalServiceManager == null) {
                throw new BootstrapException("no initial service manager!");
            }
            XUnoUrlResolver xUrlResolver = UnoUrlResolver.create((XComponentContext)xLocalContext);
            String sConnect = "uno:socket,host=localhost,port=2083;urp;StarOffice.ComponentContext";
            int i = 0;
            while (true) {
                try {
                    Object context = xUrlResolver.resolve(sConnect);
                    xContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)context);
                    if (xContext == null) {
                        throw new BootstrapException("no component context!");
                    }
                }
                catch (NoConnectException ex) {
                    if (i == 600) {
                        throw new BootstrapException((Exception)((Object)ex));
                    }
                    Thread.sleep(500L);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (BootstrapException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BootstrapException(e);
        }
        return xContext;
    }

    private static void pipe(final InputStream in, final PrintStream out, final String prefix) {
        new Thread("Pipe: " + prefix){

            @Override
            public void run() {
                try {
                    String s;
                    BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                    while ((s = r.readLine()) != null) {
                        out.println(prefix + s);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace(System.err);
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }.start();
    }
}

