/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog;

import org.jabref.gui.mergeentries.newmergedialog.FieldRowView;
import org.jabref.gui.mergeentries.newmergedialog.cell.sidebuttons.InfoButton;
import org.jabref.gui.mergeentries.newmergedialog.fieldsmerger.FieldMergerFactory;
import org.jabref.logic.importer.AuthorListParser;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.preferences.PreferencesService;

public class PersonsNameFieldRowView
extends FieldRowView {
    private final AuthorList leftEntryNames;
    private final AuthorList rightEntryNames;

    public PersonsNameFieldRowView(Field field, BibEntry leftEntry, BibEntry rightEntry, BibEntry mergedEntry, FieldMergerFactory fieldMergerFactory, PreferencesService preferencesService, int rowIndex) {
        super(field, leftEntry, rightEntry, mergedEntry, fieldMergerFactory, preferencesService, rowIndex);
        assert (field.getProperties().contains((Object)FieldProperty.PERSON_NAMES));
        AuthorListParser authorsParser = new AuthorListParser();
        this.leftEntryNames = authorsParser.parse(this.viewModel.getLeftFieldValue());
        this.rightEntryNames = authorsParser.parse(this.viewModel.getRightFieldValue());
        if (!this.viewModel.hasEqualLeftAndRightValues() && this.leftEntryNames.equals(this.rightEntryNames)) {
            this.showPersonsNamesAreTheSameInfo();
            this.shouldShowDiffs.set(false);
        }
    }

    private void showPersonsNamesAreTheSameInfo() {
        InfoButton infoButton = new InfoButton(Localization.lang("The %0s are the same. However, the order of field content differs", this.viewModel.getField().getName()));
        this.getFieldNameCell().addSideButton(infoButton);
    }
}

