/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries;

import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import org.jabref.gui.mergeentries.EntriesMergeResult;
import org.jabref.gui.mergeentries.newmergedialog.ShowDiffConfig;
import org.jabref.gui.mergeentries.newmergedialog.ThreeWayMergeView;
import org.jabref.gui.util.BaseDialog;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;

public class MergeEntriesDialog
extends BaseDialog<EntriesMergeResult> {
    private final ThreeWayMergeView threeWayMergeView;
    private final BibEntry one;
    private final BibEntry two;

    public MergeEntriesDialog(BibEntry one, BibEntry two, PreferencesService preferencesService) {
        this.threeWayMergeView = new ThreeWayMergeView(one, two, preferencesService);
        this.one = one;
        this.two = two;
        this.init();
    }

    private void init() {
        this.setX(20.0);
        this.setY(20.0);
        this.getDialogPane().setContent((Node)this.threeWayMergeView);
        ButtonType replaceEntries = new ButtonType(Localization.lang("Merge entries", new Object[0]), ButtonBar.ButtonData.OK_DONE);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CANCEL, replaceEntries});
        this.setResultConverter(buttonType -> {
            this.threeWayMergeView.saveConfiguration();
            if (buttonType.equals(replaceEntries)) {
                return new EntriesMergeResult(this.one, this.two, this.threeWayMergeView.getLeftEntry(), this.threeWayMergeView.getRightEntry(), this.threeWayMergeView.getMergedEntry());
            }
            return null;
        });
    }

    public void setLeftHeaderText(String leftHeaderText) {
        this.threeWayMergeView.setLeftHeader(leftHeaderText);
    }

    public void setRightHeaderText(String rightHeaderText) {
        this.threeWayMergeView.setRightHeader(rightHeaderText);
    }

    public void configureDiff(ShowDiffConfig diffConfig) {
        this.threeWayMergeView.showDiff(diffConfig);
    }
}

