/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autocompleter;

import java.util.Locale;
import org.jabref.gui.autocompleter.AutoCompletionInput;
import org.jabref.gui.autocompleter.AutoCompletionStrategy;

public class AppendWordsStrategy
implements AutoCompletionStrategy {
    protected String getDelimiter() {
        return " ";
    }

    @Override
    public AutoCompletionInput analyze(String input) {
        return this.determinePrefixAndReturnRemainder(input, this.getDelimiter());
    }

    private AutoCompletionInput determinePrefixAndReturnRemainder(String input, String delimiter) {
        int index = input.toLowerCase(Locale.ROOT).lastIndexOf(delimiter);
        if (index >= 0) {
            String prefix = input.substring(0, index + delimiter.length());
            String rest = input.substring(index + delimiter.length());
            return new AutoCompletionInput(prefix, rest);
        }
        return new AutoCompletionInput("", input);
    }
}

